package com.example.sefinsa_app.ui.avales;

import android.app.ProgressDialog;
import android.content.BroadcastReceiver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.SearchView;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.navigation.Navigation;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkInfo;
import androidx.work.WorkManager;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.AvalesWorker;
import com.example.sefinsa_app.ClientesWorker;
import com.example.sefinsa_app.NetworkChangeReceiver;
import com.example.sefinsa_app.NetworkSpeedChecker;
import com.example.sefinsa_app.R;
import com.example.sefinsa_app.VolleySingleton;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.AvalController;
import com.example.sefinsa_app.controllers.ColocadoraController;
import com.example.sefinsa_app.controllers.PoblacionController;
import com.example.sefinsa_app.controllers.RutaController;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Aval;
import com.example.sefinsa_app.models.Cliente;
import com.example.sefinsa_app.models.Colocadora;
import com.example.sefinsa_app.models.Poblacion;
import com.example.sefinsa_app.models.Prestamo;
import com.example.sefinsa_app.models.Ruta;
import com.example.sefinsa_app.ui.clientes.ClientesFragment;
import com.example.sefinsa_app.utilities.AvalesAdapter;
import com.example.sefinsa_app.utilities.ClientesAdapter;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.ResponseMe;
import com.example.sefinsa_app.utilities.RetrofitInterface;
import com.example.sefinsa_app.utilities.VolleyS;
import com.facebook.shimmer.ShimmerFrameLayout;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class AvalesFragment extends Fragment implements NetworkChangeReceiver.NetworkChangeListener {

    private AvalesViewModel mViewModel;
    public static ArrayList<Aval> avales, avalesFiltrados;
    private VolleyS vs;
    private RequestQueue requestQueue;

    public static SearchView svAvales;
    private static ShimmerFrameLayout shimmer;
    private static RecyclerView recyclerView;
    public static AvalesAdapter avalesAdapter;
    private LinearLayoutManager linearLayoutManager;
    private FloatingActionButton fabCrearAval;
    private boolean isReceiverRegistered = false;
    private boolean isNetworkReceiverRegistered = false;
    private SharedPreferences sesion;
    private TextView textViewMensajes;
    private AvalController avalController;
    private RutaController rutaController;
    private PoblacionController poblacionController;
    private ColocadoraController colocadoraController;
    private ArrayList<Ruta> rutas;
    private ArrayList<Poblacion> poblaciones;
    private ArrayList<Colocadora> colocadoras;
    private static ProgressDialog dialog;
    private NetworkChangeReceiver networkChangeReceiver;
    private NetworkSpeedChecker speedChecker;
    private boolean isConnected = true;
    private static boolean isShimmerActive = false;
    private int retryCount = 0; // Contador de reintentos
    private static final int MAX_RETRIES = 80; // Máximo de reintentos
    public static AvalesFragment newInstance() {
        return new AvalesFragment();
    }
    public boolean isFragmentVisible() {
        return isVisible();
    }
    private static final int BATCH_SIZE = 10; // Número de registros a cargar por cada petición
    private int offset = 0; // Offset inicial
    private boolean isLoading = false; // Para evitar múltiples peticiones simultáneas
    private static boolean isFiltering = false;  // Bandera para saber si se está filtrando
    @Override
    public void onCreateOptionsMenu(@NonNull Menu menu, @NonNull MenuInflater inflater) {
        super.onCreateOptionsMenu(menu, inflater);
    }

    @Override
    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        switch (item.getItemId()) {
            case R.id.action_refresh:
                // Limpiar listas y adaptador antes de refrescar
                avales.clear();
                avalesFiltrados.clear();
                if (avalesAdapter != null) {
                    avalesAdapter.clear();
                    avalesAdapter.notifyDataSetChanged();
                }

                // Limpiar cache de Volley
                if (requestQueue != null) {
                    requestQueue.getCache().clear();
                }

                // Mostrar shimmer
                if (shimmer != null) {
                    shimmer.setVisibility(View.VISIBLE);
                    shimmer.startShimmer();
                    isShimmerActive = true;
                }

                // Llamar al método que refresca desde servidor
                refrescarAvalesDesdeServidor();

                return true;
            default:
                return super.onOptionsItemSelected(item);
        }
    }

    private void refrescarAvalesDesdeServidor() {
        if (!isAdded() || getContext() == null) return;

        JSONObject data = new JSONObject();
        try {
            data.put("func", "indexApp_lotes");
            data.put("page", 0);
            data.put("size", 999999);
        } catch (JSONException e) {
            e.printStackTrace();
            stopShimmer();
            return;
        }

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlAvales, data,
                response -> {
                    try {
                        JSONArray dataArray = response.getJSONArray("data");
                        List<Aval> avalesServidor = new ArrayList<>();
                        Gson gson = new Gson();

                        for (int i = 0; i < dataArray.length(); i++) {
                            JSONObject obj = dataArray.getJSONObject(i);
                            Aval aval = gson.fromJson(obj.toString(), Aval.class);
                            avalesServidor.add(aval);
                        }

                        ExecutorService executor = Executors.newSingleThreadExecutor();
                        executor.execute(() -> {
                            DatabaseHelper dbHelper = new DatabaseHelper(getContext());
                            SQLiteDatabase db = dbHelper.getWritableDatabase();
                            db.beginTransaction();
                            try {
                                for (Aval aval : avalesServidor) {
                                    ContentValues values = new ContentValues();
                                    values.put("id", aval.getId());
                                    values.put("nombre_completo", aval.getNombre_completo());
                                    values.put("direccion", aval.getDireccion());
                                    values.put("telefono", aval.getTelefono());
                                    values.put("garantias", aval.getGarantias());
                                    values.put("carpeta_comprobantes", aval.getCarpeta_comprobantes());
                                    values.put("carpeta_garantias", aval.getCarpeta_garantias());
                                    values.put("otras_referencias", aval.getOtras_referencias());
                                    values.put("created_at", aval.getCreated_at());
                                    values.put("updated_at", aval.getUpdated_at());
                                    values.put("update_comprobantes", aval.getUpdate_comprobantes_Enaval());
                                    values.put("update_garantias", aval.getUpdate_garantias_Enaval());
                                    values.put("ruta_id", aval.getRuta_id() != null ? aval.getRuta_id() : "NULL");
                                    values.put("poblacion_id", aval.getPoblacion_id() != null ? aval.getPoblacion_id() : "NULL");
                                    values.put("colocadora_id", aval.getColocadora_id() != null ? aval.getColocadora_id() : "NULL");

                                    db.insertWithOnConflict("avales", null, values, SQLiteDatabase.CONFLICT_REPLACE);
                                }
                                db.setTransactionSuccessful();
                            } finally {
                                db.endTransaction();
                                db.close();
                            }

                            // Leer de SQLite y actualizar UI
                            List<Aval> avalesActualizados = new ArrayList<>();
                            SQLiteDatabase dbRead = dbHelper.getReadableDatabase();
                            Cursor cursor = dbRead.rawQuery("SELECT * FROM avales ORDER BY id DESC", null);
                            if (cursor != null && cursor.moveToFirst()) {
                                do {
                                    Aval aval = new Aval(
                                            cursor.getString(cursor.getColumnIndexOrThrow("id")),
                                            cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo")),
                                            cursor.getString(cursor.getColumnIndexOrThrow("direccion")),
                                            cursor.getString(cursor.getColumnIndexOrThrow("telefono")),
                                            cursor.getString(cursor.getColumnIndexOrThrow("garantias")),
                                            cursor.getString(cursor.getColumnIndexOrThrow("carpeta_comprobantes")),
                                            cursor.getString(cursor.getColumnIndexOrThrow("carpeta_garantias")),
                                            cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias")),
                                            cursor.getString(cursor.getColumnIndexOrThrow("created_at")),
                                            cursor.getString(cursor.getColumnIndexOrThrow("updated_at")),
                                            cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")),
                                            cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")),
                                            cursor.getString(cursor.getColumnIndexOrThrow("colocadora_id")),
                                            cursor.getString(cursor.getColumnIndexOrThrow("update_comprobantes")),
                                            cursor.getString(cursor.getColumnIndexOrThrow("update_garantias"))
                                    );
                                    avalesActualizados.add(aval);
                                } while (cursor.moveToNext());
                                cursor.close();
                            }
                            dbRead.close();

                            // Actualizar UI en hilo principal
                            getActivity().runOnUiThread(() -> {
                                avales.clear();
                                avales.addAll(avalesActualizados);
                                updateUIWithAvales(avales);
                                stopShimmer();
                            });
                        });
                        executor.shutdown();
                    } catch (JSONException e) {
                        e.printStackTrace();
                        stopShimmer();
                    }
                },
                error -> {
                    Log.e("AvalesFragment", "Error al refrescar avales: " + error.toString());
                    stopShimmer();
                }
        );

        request.setRetryPolicy(new DefaultRetryPolicy(
                15000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT
        ));

        VolleySingleton.getInstance(getContext()).addToRequestQueue(request);
    }





    /** Método que carga todos los avales desde SQLite en orden descendente */
    private void cargarAvalesDesdeSQLiteDesc() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(() -> {
            DatabaseHelper dbHelper = new DatabaseHelper(getContext());
            SQLiteDatabase db = dbHelper.getReadableDatabase();

            String query = "SELECT * FROM avales ORDER BY id DESC"; // Descendente por ID
            Cursor cursor = db.rawQuery(query, null);

            List<Aval> nuevosAvales = new ArrayList<>();
            if (cursor != null && cursor.moveToFirst()) {
                do {
                    Aval aval = new Aval(
                            cursor.getString(cursor.getColumnIndexOrThrow("id")),
                            cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo")),
                            cursor.getString(cursor.getColumnIndexOrThrow("direccion")),
                            cursor.getString(cursor.getColumnIndexOrThrow("telefono")),
                            cursor.getString(cursor.getColumnIndexOrThrow("garantias")),
                            cursor.getString(cursor.getColumnIndexOrThrow("carpeta_comprobantes")),
                            cursor.getString(cursor.getColumnIndexOrThrow("carpeta_garantias")),
                            cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias")),
                            cursor.getString(cursor.getColumnIndexOrThrow("created_at")),
                            cursor.getString(cursor.getColumnIndexOrThrow("updated_at")),
                            cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")),
                            cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")),
                            cursor.getString(cursor.getColumnIndexOrThrow("colocadora_id")),
                            cursor.getString(cursor.getColumnIndexOrThrow("update_comprobantes")),
                            cursor.getString(cursor.getColumnIndexOrThrow("update_garantias"))
                    );
                    nuevosAvales.add(aval);
                } while (cursor.moveToNext());
                cursor.close();
            }

            db.close();

            getActivity().runOnUiThread(() -> {
                avales.clear();
                avales.addAll(nuevosAvales);
                updateUIWithAvales(avales);
            });

            executor.shutdown();
        });
    }


    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container,
                             @Nullable Bundle savedInstanceState) {

        setHasOptionsMenu(true); // Permite que el fragmento maneje los eventos de menú
        requireActivity().setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_UNSPECIFIED); // Establece la orientación de la actividad
        networkChangeReceiver = new NetworkChangeReceiver(this);
        return inflater.inflate(R.layout.fragment_avales, container, false); // Infla el layout del fragmento
    }

    @Override
    public void onViewStateRestored(@Nullable Bundle savedInstanceState) {
        super.onViewStateRestored(savedInstanceState);
        if (svAvales != null)
            svAvales.setQuery("", false);
    }
    public static void startShimmer() {
        if (shimmer != null) { // Verificar que la referencia no sea nula
            shimmer.startShimmer();
            shimmer.setVisibility(View.VISIBLE); // Asegurarte de que sea visible
            isShimmerActive = true; // Marcar que el shimmer está activo
        }
    }

    public static void stopShimmer() {
        if (shimmer != null) { // Verificar que la referencia no sea nula
            shimmer.stopShimmer();
            shimmer.setVisibility(View.GONE); // Asegurarte de que sea visible
            isShimmerActive = false; // Marcar que el shimmer está activo
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        // Desregistrar el BroadcastReceiver
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        retryCount = 0;
        vs = VolleyS.getInstance(requireContext());
        requestQueue = vs.getRequestQueue();
        CurrentFragment.fragment = "AvalesFragment";
        textViewMensajes = requireActivity().findViewById(R.id.message_text);
        sesion = requireActivity().getSharedPreferences("sesion", Context.MODE_PRIVATE);
        avalController = new AvalController(requireActivity());
        rutaController = new RutaController(requireActivity());
        poblacionController = new PoblacionController(requireActivity());
        colocadoraController = new ColocadoraController(requireActivity());

        rutas = new ArrayList<>();
        poblaciones = new ArrayList<>();
        colocadoras = new ArrayList<>();
        avales = new ArrayList<>();

        FragmentManager fm = requireActivity().getSupportFragmentManager();
        for (int i = 0; i < fm.getBackStackEntryCount(); ++i) {
            fm.popBackStack();
        }

        shimmer = view.findViewById(R.id.sfAvales);
        startShimmer();

        recyclerView = view.findViewById(R.id.rvAvales);
        svAvales = view.findViewById(R.id.svAvales);
        fabCrearAval = view.findViewById(R.id.fabCrearAval);
        avales = new ArrayList<>();

        if (sesion.getString("nombre_perfil", "").equals("COBRADOR") ||
                sesion.getString("nombre_perfil", "").equals("GESTOR")) {
            fabCrearAval.setVisibility(View.INVISIBLE);
        }

        // Listener para crear aval
        fabCrearAval.setOnClickListener(view1 -> {
            try {
                Navigation.findNavController(requireActivity(), R.id.nav_host_fragment_content_dashboard)
                        .navigate(R.id.nav_avales_crear);
            } catch (Exception e) {
                Log.e("NavigationError", "Error al navegar", e);
                Toast.makeText(requireActivity(), "Error al navegar", Toast.LENGTH_SHORT).show();
            }
        });

        svAvales.setOnQueryTextListener(new SearchView.OnQueryTextListener() {
            @Override
            public boolean onQueryTextSubmit(String query) {
                filtrarAvales(query);
                return false;
            }
            @Override
            public boolean onQueryTextChange(String newText) {
                filtrarAvales(newText);
                return false;
            }
        });

        linearLayoutManager = new LinearLayoutManager(getContext());
        recyclerView.setLayoutManager(linearLayoutManager);

        avalesAdapter = new AvalesAdapter(requireActivity(), avales);
        recyclerView.setAdapter(avalesAdapter);


        if (!sesion.getString("nombre_perfil", "").equals("JURIDICO")) {
            dialog = new ProgressDialog(requireActivity(), R.style.AppMaterialAlertDialogStyle);
            dialog.setMessage("Cargando datos, por favor espere...");
            dialog.setCanceledOnTouchOutside(false);
            dialog.show();
        }

        // Verificar si hay conexión antes de intentar cargar datos
        if (!isNetworkAvailable()) {
            AvalesWorker.isTaskAvalesCompleted = true;
            checkForUpdatesAndLoadCache();
            stopShimmer();
            // Mostrar el RecyclerView
            recyclerView.setVisibility(View.VISIBLE);
            // Ocultar el ProgressDialog si está mostrando
            if (dialog != null && dialog.isShowing()) {
                dialog.dismiss();
            }
            new Handler(Looper.getMainLooper()).postDelayed(new Runnable() {
                @Override
                public void run() {
                    checkForUpdatesAndLoadCache();
                }
            }, 500); // 3000 milisegundos = 3 segundos
        }

        recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener() {
            @Override
            public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);

                // Si estamos filtrando, no cargamos más datos
                if (isFiltering) {
                    return;
                }

                // Verificar si el usuario ha llegado cerca del final del RecyclerView
                LinearLayoutManager layoutManager = (LinearLayoutManager) recyclerView.getLayoutManager();
                if (layoutManager != null && !isLoading) {
                    int visibleItemCount = layoutManager.getChildCount();
                    int totalItemCount = layoutManager.getItemCount();
                    int pastVisibleItems = layoutManager.findFirstVisibleItemPosition();

                    // Definir un margen para pre-cargar antes de llegar al final (por ejemplo, 5 elementos antes de llegar al final)
                    int preloadMargin = 5;  // Número de elementos antes de llegar al final

                    // Si estamos cerca del final y no estamos cargando más
                    if ((visibleItemCount + pastVisibleItems) >= (totalItemCount - preloadMargin)) {
                        // Usamos post() para cargar más datos
                        recyclerView.post(() -> {
                            // Esto asegura que la carga de datos se ejecute después del ciclo actual de UI
                            loadMoreAvales();
                        });
                    }
                }
            }
        });

        if (!isAdded() || getContext() == null) {
            Log.e("ClientesFragment", "El fragmento no está listo. Operación abortada onResume.");
            return;
        }
        avales.clear();
        avalesAdapter.notifyDataSetChanged();
        getRutas();
        getPoblaciones();

        if (rutaController.tablaExiste() && poblacionController.tablaExiste()) {
            getColocadoras();
        }

        if (isNetworkAvailable()) {
            countAvalesInSQLite(requireContext(), 2, new AvalesFragment.CountAvalesCallback() {
                @Override
                public void onResult(boolean result) {
                    // Si result es true, significa que hay menos de 2 registros en la tabla
                    if (result) {
                        AvalesWorker.currentPageAvales = 0;
                        AvalesWorker.allDataLoadedAvales = false;
                        AvalesWorker.isTaskAvalesCompleted = false;
                        AvalesWorker.enqueueWork(requireContext());
                        new Handler(Looper.getMainLooper()).postDelayed(new Runnable() {
                            @Override
                            public void run() {
                                checkForUpdatesAndLoadCache();
                            }
                        }, 3000); // 4000 milisegundos = 4 segundos
                        Log.d("PRESTAMOS", "Cargando enqueueWork menos de 2 registros.");
                    } else {
                        // Si result es false, significa que hay más de 2 registros
                        AvalesWorker.currentPageAvales = 0;
                        AvalesWorker.allDataLoadedAvales = true;
                        AvalesWorker.isTaskAvalesCompleted = false;
                        AvalesWorker.enqueueWork(requireContext());
                        new Handler(Looper.getMainLooper()).postDelayed(new Runnable() {
                            @Override
                            public void run() {
                                checkForUpdatesAndLoadCache();
                            }
                        }, 1000); // 4000 milisegundos = 4 segundos
                        Log.d("PRESTAMOS", "Cargando desde caché, más de 2 registros.");
                    }
                }
            });
        } else {
            AvalesWorker.isTaskAvalesCompleted = true;
            stopShimmer();
            // Mostrar el RecyclerView
            recyclerView.setVisibility(View.VISIBLE);
            // Ocultar el ProgressDialog si está mostrando
            // Ocultar el ProgressDialog si está mostrando
            if (dialog != null && dialog.isShowing()) {
                dialog.dismiss();
            }
            new Handler(Looper.getMainLooper()).postDelayed(new Runnable() {
                @Override
                public void run() {
                    checkForUpdatesAndLoadCache();
                }
            }, 500); // 500 milisegundos = 5 mili segundos
        }
    }

    @Override
    public void onResume() {
        super.onResume();


    }

    private void checkForUpdatesAndLoadCache() {
        // Verificar si el fragmento está adjunto a la actividad
        if (!isAdded() || getContext() == null) {
            Log.e("AvalesFragment", "El fragmento no está adjunto. Operación abortada.");
            return;
        }

        // Verificar si la tarea ya se completó
        if (AvalesWorker.isTaskAvalesCompleted) {
            Log.d("Avales", "Cargando AvalesWorker.isTaskAvalesCompleted: " + AvalesWorker.isTaskAvalesCompleted);
            cargarAvalesDesdeSQLite(offset, BATCH_SIZE);
            AvalesWorker.isTaskAvalesCompleted = false; // Reiniciar la bandera
            retryCount = 0; // Reiniciar contador
        } else {
            // Si la tarea no se ha completado, reintentar
            if (retryCount < MAX_RETRIES) {
                retryCount++;
                // Volver a intentar si sigue adjunto
                new Handler(Looper.getMainLooper()).postDelayed(() -> {
                    // Verificar si el fragmento sigue adjunto antes de intentar nuevamente
                    if (isAdded() && getContext() != null) {
                        checkForUpdatesAndLoadCache(); // Volver a intentar si sigue adjunto
                    } else {
                        Log.e("ClientesFragment", "El fragmento no está adjunto. Operación abortada.");
                        // Si no está adjunto, realiza la tarea sin interactuar con la UI del fragmento
                        // Por ejemplo, puedes realizar la tarea sin intentar actualizar la UI.
                        cargarAvalesDesdeSQLite(offset, BATCH_SIZE);
                    }
                }, 2000); // Esperar 4 segundos antes de verificar nuevamente
            } else {
                Log.d("PRESTAMOS", "Número máximo de reintentos alcanzado. No se puede cargar la caché.");
                // Aquí puedes decidir qué hacer si no se completó la tarea después de varios intentos
            }
        }
    }

    private void cargarAvalesDesdeSQLite(int offset, int batchSize) {
        ExecutorService executor = Executors.newSingleThreadExecutor();

        executor.execute(() -> {
            // Abrir conexión a la base de datos
            DatabaseHelper dbHelper = new DatabaseHelper(getContext());
            SQLiteDatabase db = dbHelper.getReadableDatabase();

            // Definir columnas que quieres obtener
            String query = "SELECT avales.* " +
                    "FROM avales " +
                    "GROUP BY avales.id " +
                    "ORDER BY avales.id DESC " +
                    "LIMIT ? OFFSET ?";

            // Hacer la consulta con LIMIT y OFFSET para la paginación
            Cursor cursor = db.rawQuery(query, new String[]{String.valueOf(batchSize), String.valueOf(offset)});

            List<Aval> nuevosAvales = new ArrayList<>();
            if (cursor != null && cursor.moveToFirst()) {
                do {
                    Aval aval = new Aval(
                            cursor.getString(cursor.getColumnIndexOrThrow("id")),
                            cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo")),
                            cursor.getString(cursor.getColumnIndexOrThrow("direccion")),
                            cursor.getString(cursor.getColumnIndexOrThrow("telefono")),
                            cursor.getString(cursor.getColumnIndexOrThrow("garantias")),
                            cursor.getString(cursor.getColumnIndexOrThrow("carpeta_comprobantes")),
                            cursor.getString(cursor.getColumnIndexOrThrow("carpeta_garantias")),
                            cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias")),
                            cursor.getString(cursor.getColumnIndexOrThrow("created_at")),
                            cursor.getString(cursor.getColumnIndexOrThrow("updated_at")),
                            cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")),
                            cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")),
                            cursor.getString(cursor.getColumnIndexOrThrow("colocadora_id")),
                            cursor.getString(cursor.getColumnIndexOrThrow("update_comprobantes")),
                            cursor.getString(cursor.getColumnIndexOrThrow("update_garantias"))
                    );

                    nuevosAvales.add(aval);
                    //Log.d("AvalesFragment", "Total de avales cargados en esta consulta: " + nuevosAvales);
                } while (cursor.moveToNext());
                cursor.close();
            }

            db.close();  // Cerrar conexión a la base de datos

            // Contar registros obtenidos
            int totalAvales = nuevosAvales.size();
            getActivity().runOnUiThread(() -> {
                if (isAdded() && isVisible() && getActivity() != null) {
                    avales.addAll(nuevosAvales);
                    // Actualizar la UI con los nuevos datos
                    if (totalAvales > 0 && isAdded() && isVisible()) {
                        // Agregar los nuevos avales a la lista existente
                        Log.d("ClientesFragment", "totalAvales avales para updateUIWithClientes." + avales.size());
                        updateUIWithAvales(avales);  // Actualiza la UI con la lista de avales
                        isLoading = false;
                    } else {
                        Log.d("AvalesFragment", "No hay más avales para cargar.");
                    }
                }
                // Apagar el Executor después de completar la tarea
            });
            executor.shutdown();
        });
    }

    public static void updateUIWithAvales(List<Aval> avales) {
        if (avales == null || avales.isEmpty()) {
            Log.w("AvalesFragment", "La lista de clientes está vacía o es nula. No hay nada que mostrar.");
            return;
        }

        for (Aval aval : avales) {
            if (aval == null) {
                Log.e("AvalesFragment", "Se encontró un cliente nulo en la lista.");
                return;
            }
        }

        if (avalesAdapter == null) {
            Log.e("AvalesFragment", "El adaptador de clientes es nulo. Asegúrate de inicializarlo.");
            return;
        }

        if (recyclerView == null) {
            Log.e("AvalesFragment", "El RecyclerView no está inicializado.");
            return;
        }

        // Actualizar lista en el adaptador
        avalesAdapter.setListaFiltrada((ArrayList<Aval>) avales);

        // Notificar cambios en el adaptador
        avalesAdapter.notifyDataSetChanged();

        // Validar cambios
        Log.d("AvalesFragment", "Avales Adapter Data (después): " + avalesAdapter.getItemCount());

        // Asegurar que RecyclerView sea visible
        if (recyclerView.getVisibility() != View.VISIBLE) {
            recyclerView.setVisibility(View.VISIBLE);
            Log.d("AvalesFragment", "RecyclerView ahora está visible.");
        }

        // Detener shimmer si está activo
        if (shimmer != null && shimmer.getVisibility() == View.VISIBLE) {
            Log.d("AvalesFragment", "Deteniendo el shimmer...");
            stopShimmer();
            isShimmerActive = false;
        }

        // Ocultar el ProgressDialog
        if (dialog != null && dialog.isShowing()) {
            dialog.dismiss();
        }
    }

    // Método para verificar la conectividad de red
    private boolean isNetworkAvailable() {
        ConnectivityManager connectivityManager = (ConnectivityManager) requireContext().getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }

    @Override
    public void onNetworkChanged(boolean isConnected) {
        this.isConnected = isConnected;

        if (speedChecker == null) {
            // Obtener referencia al TextView
            speedChecker = new NetworkSpeedChecker(requireActivity(), textViewMensajes);
        }
        if (isConnected) {
            speedChecker.startChecking();
            AvalesWorker.isTaskAvalesCompleted = false;
            AvalesWorker.enqueueWork(getContext());
            checkForUpdatesAndLoadCache();
            if (textViewMensajes != null) {
                textViewMensajes.setVisibility(View.VISIBLE);
                textViewMensajes.setText("");
            }
        } else {
            if (textViewMensajes != null) {
                textViewMensajes.setVisibility(View.VISIBLE);
                textViewMensajes.setText("¡SIN INTERNET!");
                stopShimmer();
                // Mostrar el RecyclerView
                recyclerView.setVisibility(View.VISIBLE);
            }
            if (speedChecker != null) {
                speedChecker.stopChecking();
                stopShimmer();
                // Mostrar el RecyclerView
                recyclerView.setVisibility(View.VISIBLE);
            }
        }
        if (sesion.getString("nombre_perfil", "").equals("COBRADOR") || sesion.getString("nombre_perfil", "").equals("GESTOR")) {
            if (isConnected && AvalesWorker.allDataLoadedAvales) {
                // Ocultar el textViewMensajes si está visible
                hideTextViewAfterDelay();
                //getPrestamos(modalidad_id); // Verificar actualizaciones en lugar de cargar nuevo lote
            }
        }
    }
    private void hideTextViewAfterDelay() {
        if (textViewMensajes != null && textViewMensajes.getVisibility() == View.VISIBLE) {
            new Handler(Looper.getMainLooper()).postDelayed(() -> {
                textViewMensajes.setVisibility(View.VISIBLE);
                textViewMensajes.setText("");
            }, 3000);
        }
    }
    @Override
    public void onDestroy() {
        super.onDestroy();
        if (speedChecker != null) {
            speedChecker.stopChecking();
        }
    }
    private final Handler handler = new Handler(Looper.getMainLooper());

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        handler.removeCallbacksAndMessages(null); // Cancelar todas las tareas pendientes
    }
    private void countAvalesInSQLite(Context context, int threshold, CountAvalesCallback callback) {
        ExecutorService executor = Executors.newSingleThreadExecutor();

        executor.execute(() -> {
            // Abrir conexión a la base de datos
            DatabaseHelper dbHelper = new DatabaseHelper(context);
            SQLiteDatabase db = dbHelper.getReadableDatabase();

            int totalAvales; // Inicializamos el conteo

            // Consulta para contar los registros en la tabla "avales"
            Cursor cursor = db.rawQuery("SELECT COUNT(*) FROM avales", null);

            if (cursor != null) {
                if (cursor.moveToFirst()) {
                    totalAvales = cursor.getInt(0); // Obtiene el conteo de la primera columna
                } else {
                    totalAvales = 0;
                }
                cursor.close(); // Cerrar el cursor
            } else {
                totalAvales = 0;
            }

            db.close(); // Cerrar la conexión a la base de datos

            Log.d("SQLite", "Total registros en SQLite: " + totalAvales);

            // Devolver el resultado al hilo principal
            getActivity().runOnUiThread(() -> {
                callback.onResult(totalAvales < threshold);
            });

            // Apagar el Executor después de completar la tarea
            executor.shutdown();
        });
    }
    private interface CountAvalesCallback {
        void onResult(boolean result);
    }


    private void buscarAvales(String query) {
        ExecutorService executor = Executors.newSingleThreadExecutor();

        executor.execute(() -> {
            if (isAdded() && getContext() != null) {
                DatabaseHelper dbHelper = new DatabaseHelper(requireContext());
                SQLiteDatabase db = dbHelper.getReadableDatabase();

                Log.d("AvalesFragment", "Ejecutando búsqueda en la base de datos con query: " + query);

                String sqlQuery = "SELECT avales.*, " +
                        "clientes.nombre_completo as nombre_cliente, clientes.direccion as direccion_cliente, clientes.telefono as telefono_cliente " +
                        "FROM avales " +
                        "LEFT JOIN prestamos ON prestamos.aval_id = avales.id " +
                        "LEFT JOIN clientes ON clientes.id = prestamos.cliente_id " +
                        "WHERE avales.nombre_completo LIKE ? " + // Filtrar por nombre del aval
                        "ORDER BY avales.id DESC ";

                Cursor cursor = db.rawQuery(sqlQuery, new String[]{"%" + query + "%"});
                if (cursor != null && cursor.moveToFirst()) {
                    Log.d("AvalesFragment", "Avales encontrados en la base de datos: " + cursor.getCount());

                    Set<String> idsEncontrados = new HashSet<>(); // Para evitar duplicados en memoria

                    do {
                        String avalId = cursor.getString(cursor.getColumnIndexOrThrow("id"));

                        // Verificar si el aval ya está en la lista
                        if (!idsEncontrados.contains(avalId)) {
                            Aval aval = new Aval(
                                    avalId,
                                    cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo")),
                                    cursor.getString(cursor.getColumnIndexOrThrow("direccion")),
                                    cursor.getString(cursor.getColumnIndexOrThrow("telefono")),
                                    cursor.getString(cursor.getColumnIndexOrThrow("garantias")),
                                    cursor.getString(cursor.getColumnIndexOrThrow("carpeta_comprobantes")),
                                    cursor.getString(cursor.getColumnIndexOrThrow("carpeta_garantias")),
                                    cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias")),
                                    cursor.getString(cursor.getColumnIndexOrThrow("created_at")),
                                    cursor.getString(cursor.getColumnIndexOrThrow("updated_at")),
                                    cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")),
                                    cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")),
                                    cursor.getString(cursor.getColumnIndexOrThrow("colocadora_id")),
                                    cursor.getString(cursor.getColumnIndexOrThrow("update_comprobantes")),
                                    cursor.getString(cursor.getColumnIndexOrThrow("update_garantias"))
                            );

                            // Agregar aval a la lista principal
                            avales.add(aval);
                            idsEncontrados.add(avalId);

                            // Agregar el aval a la lista filtrada
                            if (avalesFiltrados == null) {
                                avalesFiltrados = new ArrayList<>();
                            }
                            avalesFiltrados.add(aval);

                            getActivity().runOnUiThread(() -> {
                                avalesAdapter.setListaFiltrada(avalesFiltrados);
                                avalesAdapter.notifyItemInserted(avalesFiltrados.size() - 1);
                            });
                        }
                    } while (cursor.moveToNext());

                    cursor.close();
                } else {
                    Log.d("AvalesFragment", "No se encontraron avales para la query: " + query);
                }
                db.close();
            } else {
                Log.e("AvalesFragment", "Fragment no activo o contexto no disponible.");
            }

            // Apagar el Executor después de completar la tarea
            executor.shutdown();
        });
    }

    public void filtrarAvales(String text) {
        Log.d("AvalesFragment", "Texto para filtrar: " + text);

        if (text.isEmpty()) {
            Log.d("AvalesFragment", "Texto vacío, restableciendo lista completa.");

            // Si el texto está vacío, restablecer los avales filtrados con todos los avales disponibles
            avalesFiltrados = new ArrayList<>(avales);  // Suponiendo que tienes una lista original llamada 'avales'
            isFiltering = false;
            // Actualiza la UI con la lista completa
            avalesAdapter.setListaFiltrada(avalesFiltrados);
            avalesAdapter.notifyDataSetChanged();


        } else {
            // Filtrar en memoria los avales
            Log.d("AvalesFragment", "Realizando filtrado en memoria.");

            // Usar un Set para evitar duplicados
            Set<Aval> uniqueAvalesFiltrados = new HashSet<>();

            for (Aval aval : avales) {
                String textoFiltro = aval.getNombre_completo();
                if (textoFiltro.toLowerCase().contains(text.toLowerCase())) {
                    uniqueAvalesFiltrados.add(aval);
                }
            }

            // Actualizar la lista filtrada
            avalesFiltrados = new ArrayList<>(uniqueAvalesFiltrados);
            Log.d("AvalesFragment", "Avales encontrados en memoria: " + avalesFiltrados.size());

            if (!avalesFiltrados.isEmpty()) {
                // Si hay coincidencias, actualiza el adaptador
                isFiltering = true;
                avalesAdapter.setListaFiltrada(avalesFiltrados);
                avalesAdapter.notifyDataSetChanged();

            } else {
                // Si no hay coincidencias, buscar en la base de datos
                Log.d("AvalesFragment", "No se encontraron coincidencias en memoria. Buscando en SQLite.");
                buscarAvales(text); // Llamar a la función de búsqueda
            }
        }
    }

    private void loadMoreAvales() {
        if (!isLoading) {
            isLoading = true; // Marcar como cargando

            // Incrementar el offset para la próxima carga
            offset += BATCH_SIZE;

            // Llamar a la función para cargar más clientes desde SQLite
            cargarAvalesDesdeSQLite(offset, BATCH_SIZE);
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        // Registrar el receiver solo si no está registrado
        if (!isReceiverRegistered) {
            isReceiverRegistered = true; // Marcar como registrado
        }

        // Registrar el networkChangeReceiver solo si no está registrado
        if (!isNetworkReceiverRegistered) {
            IntentFilter filter = new IntentFilter(ConnectivityManager.CONNECTIVITY_ACTION);
            requireActivity().registerReceiver(networkChangeReceiver, filter);
            isNetworkReceiverRegistered = true; // Marcar como registrado
        }

        // Iniciar el speedChecker si no es nulo
        if (speedChecker != null) {
            speedChecker.startChecking();
        }
    }

    @Override
    public void onStop() {
        super.onStop();
        // Solo desregistrar si está registrado
        if (isReceiverRegistered) {
            isReceiverRegistered = false;
        }

        if (isNetworkReceiverRegistered) {
            requireActivity().unregisterReceiver(networkChangeReceiver);
            isNetworkReceiverRegistered = false;
        }

        if (speedChecker != null) {
            speedChecker.stopChecking();
        }
    }

    private void getPoblaciones() {
        if (poblacionController.obtener().isEmpty()) {

            vs = VolleyS.getInstance(this.getContext());
            requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "index");
            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPoblaciones, data,
                    response -> {
                        try {

                            JSONArray data1 = (JSONArray) response.get("data");

                            for (int i = 0; i < data1.length(); i++) {

                                JSONObject obj = data1.getJSONObject(i);

                                Gson gson = new Gson();
                                Poblacion poblacion = gson.fromJson(obj.toString(), Poblacion.class);

                                poblaciones.add(poblacion);
                                poblacionController.nueva(poblacion);

                            }


                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }, error -> ErrorChecker.checker(error, requireActivity()));

            request.setRetryPolicy(new DefaultRetryPolicy(
                    80000,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            requestQueue.add(request);
        } else {
            poblaciones = poblacionController.obtener();
        }
    }

    private void getRutas() {
        if (rutaController.obtener().isEmpty()) {

            vs = VolleyS.getInstance(this.getContext());
            requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "rutasActivas");

            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlRutas, data,
                    response -> {
                        try {

                            JSONArray data1 = (JSONArray) response.get("data");

                            for (int i = 0; i < data1.length(); i++) {

                                JSONObject obj = data1.getJSONObject(i);

                                Gson gson = new Gson();
                                Ruta ruta = gson.fromJson(obj.toString(), Ruta.class);

                                rutas.add(ruta);
                                rutaController.nueva(ruta);

                            }


                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }, error -> ErrorChecker.checker(error, requireActivity()));

            request.setRetryPolicy(new DefaultRetryPolicy(
                    30000,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            requestQueue.add(request);

        }
    }

    private void getColocadoras() {
        if (colocadoraController.obtener().isEmpty()) {

            vs = VolleyS.getInstance(this.getContext());
            requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "index");
            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlColocadoras, data,
                    response -> {
                        try {

                            JSONArray data1 = (JSONArray) response.get("data");

                            for (int i = 0; i < data1.length(); i++) {

                                JSONObject obj = data1.getJSONObject(i);


                                Gson gson = new Gson();
                                Colocadora colocadora = gson.fromJson(obj.toString(), Colocadora.class);

                                colocadoras.add(colocadora);
                                colocadoraController.nueva(colocadora);

                            }

                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }, error -> ErrorChecker.checker(error, requireActivity()));

            request.setRetryPolicy(new DefaultRetryPolicy(
                    30000,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            requestQueue.add(request);
        } else {
            colocadoras = colocadoraController.obtener();
        }

    }
}